<?php

use \Bitrix\Main\ORM\Data\DataManager;
use \Bitrix\Main\ORM\Fields\BooleanField;
use \Bitrix\Main\ORM\Fields\EnumField;
use \Bitrix\Main\ORM\Fields\IntegerField;
use \Bitrix\Main\ORM\Fields\StringField;
use \Bitrix\Main\ORM\Fields\TextField;

use \Bitrix\Main\Application;
use \Bitrix\Main\Entity\Base;

class UsersTable extends DataManager
{
    /**
     * Returns DB table name for entity.
     *
     * @return string
     */
    public static function getTableName()
    {
        return 'b_a_paykeeper_users';
    }

    /**
     * Creates database table
     *
     * @return bool
     */
    public static function createTable()
    {
        $connection = Application::getConnection(self::getConnectionName());
        $entity = Base::getInstance(self::class);

        if(!$connection->isTableExists($entity->getDBTableName()))
        {
            $entity->createDbTable();
            return true;
        }

        return false;
    }

    /**
     * Drops database table
     *
     * @return bool
     */
    public static function dropTable()
    {
        $connection = Application::getConnection(self::getConnectionName());
        $entity = Base::getInstance(self::class);

        if($connection->isTableExists($entity->getDBTableName()))
        {
            $connection->queryExecute('DROP TABLE IF EXISTS ' . $entity->getDBTableName());
            return true;
        }

        return false;
    }

    /**
     * Returns entity map definition.
     *
     * @return array
     */
    public static function getMap()
    {
        return [
            new IntegerField('ID', [
                'primary' => true,
                'autocomplete' => true
            ]),
            new IntegerField('BX_USER_ID', [ 'required' => true ]),
            new StringField('PK_BANK_ID', [ 'default_value' => '' ]),
        ];
    }

    public static function getIndexes()
    {
        return [
            'idx_bx_user_id' => [
                'columns' => ['BX_USER_ID'], // Поле для индекса
                'type' => 'INDEX', // Обычный индекс (не уникальный)
            ],
        ];
    }

    /**
     * @param int $bxUserId
     * @return mixed
     */
    public static function getByUserId($bxUserId)
    {
        return self::getRow([
            'filter' => ['=BX_USER_ID' => $bxUserId],
        ]);
    }

    /**
     * @param array $data
     * @return void
     */
    public static function addOrUpdate($data)
    {
        $currentRecord = self::getByUserId(intval($data['BX_USER_ID']));
        if ($currentRecord) {
            unset($data['ID']);
            $result = self::update($currentRecord['ID'], $data);
            if (!$result->isSuccess()) {
                Utils::paykeeperLogger([
                    'TITLE' => 'ERROR_UPDATE_USERSTABLE',
                    'ERROR' => print_r($result->getErrorMessages(), true),
                    'DATA' => print_r($data, true)
                ]);
            }
        } else {
            $result = self::add($data);
            if (!$result->isSuccess()) {
                Utils::paykeeperLogger([
                    'TITLE' => 'ERROR_ADD_USERSTABLE',
                    'ERROR' => print_r($result->getErrorMessages(), true),
                    'DATA' => print_r($data, true)
                ]);
            }
        }
        return $result;
    }
}