<?php namespace Paykeeper\PkPayShopaholic\Classes\Helper;

use Lovata\OrdersShopaholic\Classes\Helper\AbstractPaymentGateway;

/**
 * Class PaymentGateway
 * @package Paykeeper\PkPayShopaholic\Classes\Helper
 * @author Paykeeper
 */
class PaymentGateway extends AbstractPaymentGateway
{
    const CODE = 'paykeeper';
    /** @var array - response from payment gateway */
    protected $arResponse = [];
    /** @var array - request data for payment gateway */
    protected $arRequestData = [];
    protected $sRedirectURL  = '';
    protected $obResponse;

    /**
     * Get response array
     * @return array
     */
    public function getResponse(): array
    {
        return (array)$this->arResponse;
    }

    /**
     * Get redirect URL
     * @return string
     */
    public function getRedirectURL(): string
    {
        return $this->sRedirectURL;
    }

    /**
     * Get error message from payment gateway
     * @return string
     */
    public function getMessage(): string
    {
        return true;
    }

    /**
     * Prepare data for request in payment gateway
     */
    protected function preparePurchaseData()
    {
        return true;
    }

    /**
     * Validate request data
     * @return bool
     */
    protected function validatePurchaseData()
    {
        return true;
    }

    /**
     * Send request to payment gateway
     */
    protected function sendPurchaseData()
    {
        return true;
    }

    /**
     * Process response from payment gateway
     */
    protected function processPurchaseResponse()
    {
        $this->setWaitPaymentStatus();
        $this->sRedirectURL = '/paykeeper/pay?id='.$this->obOrder->id ;
        $this->bIsRedirect = true;
        $this->obOrder->payment_data = $this->arRequestData;
        $this->obOrder->payment_response = $this->obResponse;
        $this->obOrder->save();
    }

}
