<?php

use Tygh\Registry;
use Tygh\Http;

/**
 * @var array $processor_data
 * @var array $order_info
 * @var string $mode
 */
if (!defined('BOOTSTRAP')) {
    die('Access denied');
}

require_once('paykeeper.class.php');

$pk_obj = new PaykeeperPayment();
$pk_url = $processor_data['processor_params']['url'];
$pk_secret = $processor_data['processor_params']['secret'];
$pk_force_discount = isset($processor_data['processor_params']['force_discount']);
$pk_redirect_form = !isset($processor_data['processor_params']['redirect_form'])
    || $processor_data['processor_params']['redirect_form'] == 'Y';
$pk_cart_enable = !isset($processor_data['processor_params']['cart_enable'])
    || $processor_data['processor_params']['cart_enable'] == 'Y';
$pk_agent_enable = isset($processor_data['processor_params']['agent_enable'])
    && $processor_data['processor_params']['agent_enable'] == 'Y';

$payment_surcharge = floatval($order_info['payment_surcharge'])
    ? fn_paykeeper_format_price($order_info['payment_surcharge']) : 0;
$shipping_price = fn_order_shipping_cost($order_info);
$shipping_price = fn_paykeeper_format_price($shipping_price);
$total = fn_paykeeper_format_price($order_info["total"]);
$paykeeper_total = fn_paykeeper_format_price($total - $shipping_price - $payment_surcharge);
$discount_use = true;

if (!fn_paykeeper_use_gift_certificates($order_info)
    && !((float) $order_info['subtotal_discount'])
    && empty($order_info['points_info']['in_use']))
{
    $discount_use = false;
}

$pk_obj->setOrderParams(
    $paykeeper_total, //sum
    trim($order_info["firstname"] . ' ' . $order_info["lastname"]), //clientid
    $order_info["order_id"], //orderid
    $order_info["email"], //client_email
    $order_info["phone"], //client_phone
    "", //service_name
    $pk_url, //payment form url
    $pk_secret //secret key
);

if (!empty($processor_data['processor_params']['result_page'])) {
    $pk_obj->order_params['user_result_callback'] =
        str_ireplace('#orderid', $order_info["order_id"], $processor_data['processor_params']['result_page']);
}

if ($paykeeper_total > 0 && $pk_cart_enable) {
    // Default tax rate of payment
    $payment_tax_rate = fn_paykeeper_get_taxrate($order_info['payment_method']['tax_ids'], 0, 'payment');

    //GENERATE FZ54 CART
    $cart_data = $order_info['products'];
    $last_index = 0;

    foreach ($cart_data as $cart_item) {
        $taxes = array('tax' => 'none', 'tax_sum' => 0);

        $tax_rate = NULL;
        $name = strip_tags($cart_item['product']);
        $qty = (float) $cart_item['amount'];
        $price = fn_paykeeper_format_price(($cart_item['subtotal'] - fn_external_discounts($cart_item)) / $qty);

        $tax_rate = fn_paykeeper_get_taxrate($order_info['taxes'], $cart_item['item_id'], 'product');

        if (!is_null($tax_rate)) {
            $taxes = $pk_obj->setTaxes($tax_rate, false);
        } else if (!is_null($payment_tax_rate)) {
            $taxes = $pk_obj->setTaxes($payment_tax_rate, false);
        }

        $pk_obj->updateFiscalCart(
            $pk_obj->getPaymentFormType(),
            $name,
            $price,
            $qty,
            0,
            $taxes['tax']
        );

        // For correctPrecision()
        if ($qty == 1 && $pk_obj->single_item_index < 0) {
            $pk_obj->single_item_index = $last_index;
        }
        if ($qty > 1 && $pk_obj->more_then_one_item_index < 0) {
            $pk_obj->more_then_one_item_index = $last_index;
        }

        // For agent
        if ($pk_agent_enable && isset($cart_item['company_id'])) {
            // Извлечение агентских признаков товара
            $vendor_id = $cart_item['company_id']; // ID продавца товара
            $vendor_profile = fn_get_company_data($vendor_id); // Получение профиля продавца
            if (!empty($vendor_profile)) {
                $pk_agent_type = $processor_data['processor_params']['agent_type'];
                $pk_code_supplier_name = $processor_data['processor_params']['supplier_name'];
                $pk_code_supplier_inn = $processor_data['processor_params']['supplier_inn'];
                $pk_code_supplier_phones = $processor_data['processor_params']['supplier_phones'];
                $pk_agent = [];
                $pk_supplier = [
                    'phones' => [''],
                    'inn' => '',
                    'name' => ''
                ];
                if ($pk_agent_type) {
                    $pk_agent['type'] = $pk_agent_type;
                    if ($pk_agent['type'] == 'payment_agent' || $pk_agent['type'] == 'payment_subagent') {
                        $pk_agent['phones'] = [''];
                        $pk_agent['receiver_phones'] = [''];
                    } else if ($pk_agent['type'] == 'bank_agent' || $pk_agent['type'] == 'bank_subagent') {
                        $pk_agent['phones'] = [''];
                        $pk_agent['operation'] = '';
                        $pk_agent['inn'] = '';
                        $pk_agent['name'] = '';
                        $pk_agent['address'] = '';
                        $pk_agent['transfer_phones'] = [''];
                    }
                }
                if ($pk_code_supplier_phones
                    && !empty($vendor_profile[$pk_code_supplier_phones])
                    && $vendor_profile[$pk_code_supplier_phones] != '+')
                {
                    $pk_supplier_phones = str_replace([' ', '(', ')', '-'], '', $vendor_profile[$pk_code_supplier_phones]);
                    $pk_supplier_phones = preg_replace('/^\+8|^8|^7/', '+7', $pk_supplier_phones);
                    if (substr($pk_supplier_phones, 0, 1) !== '+') {
                        $pk_supplier_phones = '+' . $pk_supplier_phones;
                    }
                    $pk_supplier['phones'] = [ $pk_supplier_phones ];
                }
                if ($pk_code_supplier_inn && isset($vendor_profile[$pk_code_supplier_inn])) {
                    $pk_supplier['inn'] = $vendor_profile[$pk_code_supplier_inn];
                }
                if ($pk_code_supplier_name && isset($vendor_profile[$pk_code_supplier_name])) {
                    $pk_supplier['name'] = $vendor_profile[$pk_code_supplier_name];
                }
                if (count($pk_agent) > 0) {
                    $pk_obj->fiscal_cart[$last_index]['agent'] = $pk_agent;
                    $pk_obj->fiscal_cart[$last_index]['supplier'] = $pk_supplier;
                }
            }
        }

        $last_index++;
    }

    //set discounts of shop
    $pk_obj->setDiscounts($discount_use);

    if ($payment_surcharge > 0)  {
        $pk_obj->updateFiscalCart(
            $pk_obj->getPaymentFormType(),
            !empty($order_info['payment_method']['surcharge_title']) ? $order_info['payment_method']['surcharge_title'] : __('surcharge'),
            $payment_surcharge,
            1
        );
        $pk_obj->fiscal_cart[$last_index]['item_type'] = 'payment';
        $last_index++;
    }

    //add shipping parameters to cart
    $shipping_name = isset($order_info['shipping'][0]['shipping']) ? strip_tags($order_info['shipping'][0]['shipping']) : '';

    $pk_obj->setShippingPrice($shipping_price);

    //check if delivery already in cart
    if (!$pk_obj->checkDeliveryIncluded($pk_obj->getShippingPrice(), $shipping_name) && $pk_obj->getShippingPrice() > 0) {
        $shipping_tax_rate = NULL;
        $shipping_taxes = array('tax' => 'none', 'tax_sum' => 0);
        $shipping_tax_rate = fn_paykeeper_get_taxrate($order_info['taxes'], $order_info['shipping_ids'], 'shipping');

        if (!is_null($shipping_tax_rate)) {
            $shipping_taxes = $pk_obj->setTaxes($shipping_tax_rate, false);
        } else if (!is_null($payment_tax_rate)) {
            $shipping_taxes = $pk_obj->setTaxes($payment_tax_rate, false);
        }

        $pk_obj->setUseDelivery(); //for discount set and precision correct check
        $pk_obj->updateFiscalCart(
            $pk_obj->getPaymentFormType(),
            $shipping_name,
            $pk_obj->getShippingPrice(),
            1,
            0,
            $shipping_taxes['tax']
        );
        $pk_obj->delivery_index = $last_index;
        $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
    }

    //set discounts of payment
    $pk_obj->setOrderTotal($total);
    $pk_obj->setDiscounts($pk_force_discount);

    //handle possible precision problem
    $pk_obj->correctPrecision();
} else {
    $pk_obj->setOrderTotal($total);
}

// Generate and render payment form
echo fn_paykeeper_get_payment_form($pk_obj, $pk_redirect_form);

fn_change_order_status($order_info['order_id'], 'O');

$_SESSION['cart'] = array(
    'user_data' => !empty($_SESSION['cart']['user_data']) ? $_SESSION['cart']['user_data'] : array(),
    'profile_id' => !empty($_SESSION['cart']['profile_id']) ? $_SESSION['cart']['profile_id'] : 0,
    'user_id' => !empty($_SESSION['cart']['user_id']) ? $_SESSION['cart']['user_id'] : 0,
);
$_SESSION['shipping_rates'] = array();
unset($_SESSION['shipping_hash']);

if (function_exists('fn_user_session_products_condition')) {
    $condition = fn_user_session_products_condition();
    db_query('DELETE FROM ?:user_session_products WHERE ' . $condition);
}

exit;