<?php

require_once('paykeeper.class.php');

class ControllerPaymentPaykeeper extends Controller {

    public function index()
    {
        // Передача объекта URL в шаблон
        $data['url_link'] = $this->url->link('payment/paykeeper/gopay', '', true);

        // Ваши другие данные, которые передаются в шаблон
        $data['button_confirm'] = $this->language->get('button_confirm');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/paykeeper.tpl')) {
            return $this->load->view($this->config->get('config_template') . '/template/payment/paykeeper.tpl', $data);
        } else {
            return $this->load->view('default/template/payment/paykeeper.tpl', $data);
        }
    }

    /**
     * Callback method for handling PayKeeper payment confirmation.
     *
     * @return void Outputs success message or error message based on validation checks.
     */
    public function callback()
    {
        // Exit if no POST data is received
        if ($this->request->server['REQUEST_METHOD'] != 'POST') {
            exit;
        }

        $this->load->model('checkout/order');

        if (!isset($this->request->post['id'])
            || !isset($this->request->post['orderid'])
            || !isset($this->request->post['sum'])
            || !isset($this->request->post['key'])
        ){
            echo "Error! Invalid request!";
            exit;
        }

        // Extract and validate key parameters from POST data
        $secret_seed = $this->config->get('paykeepersecret');
        $id = $this->request->post['id'];
        $sum = $this->request->post['sum'];
        $clientid = $this->request->post['clientid'];
        $orderid = $this->request->post['orderid'];
        $key = $this->request->post['key'];

        // Validate hash to ensure data integrity
        $pk_key = md5($id . sprintf("%.2lf", $sum) . $clientid . $orderid . $secret_seed);
        if (!hash_equals($pk_key, $key)) {
            echo "Error! Hash mismatch";
            exit;
        }

        // Retrieve order details and validate the order ID
        $order_info = $this->model_checkout_order->getOrder($orderid);
        if (!isset($order_info['order_id'])) {
            echo "Error! Order was not found";
            exit;
        }

        // Verify that the order total matches the payment amount
        $order_total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
        $sum_format = number_format($sum, 2, '.', '');
        if (number_format($order_total, 2, '.', '') !== $sum_format) {
            echo "Error! Incorrect order sum!";
            exit;
        }

        // Update order status to reflect successful payment
        $this->model_checkout_order->addOrderHistory($orderid, $this->config->get('paykeeper_order_status_id'), "Заказ номер $orderid оплачен через paykeeper");

        // Output success message with confirmation hash
        echo 'OK ' . md5($id . $secret_seed);
    }

    /**
     * Initiates the payment process with PayKeeper.
     *
     * @return void Outputs the rendered PayKeeper payment page with an embedded payment form.
     */
    public function gopay()
    {
        $this->load->language('checkout/checkout');
        $this->load->language('payment/paykeeper');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_cart'),
            'href' => $this->url->link('checkout/cart')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('checkout/checkout', '', 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('paykeeper_title'),
            'href' => $this->url->link('payment/paykeeper/gopay', '', 'SSL')
        );

        $data['heading_title'] = $this->language->get('paykeeper_title');
        $this->document->setTitle($data['heading_title']);

        $this->load->model('checkout/order');

        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $data['column_left']    = $this->load->controller('common/column_left');
        $data['column_right']   = $this->load->controller('common/column_right');
        $data['content_top']    = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer']         = $this->load->controller('common/footer');
        $data['header']         = $this->load->controller('common/header');

        //GENERATING PAYKEEPER PAYMENT FORM
        $pk_obj = new PaykeeperPayment();

        //set order params
        $pk_obj->setOrderParams(
        //sum
            $this->currency->format(
                $order_info['total'],
                $order_info['currency_code'],
                $order_info['currency_value'],
                false
            ),
            //clientid
            $order_info['firstname'] . " " . $order_info['lastname'],
            //orderid
            $order_info['order_id'],
            //client_email
            $order_info['email'],
            //client_phone
            $order_info['telephone'],
            //service_name
            '',
            //payment form url
            $this->config->get('paykeeperserver'),
            //secret key
            $this->config->get('paykeepersecret')
        );

        //GENERATE FZ54 CART
        $this->load->model('account/order');
        $order_items = $this->model_account_order->getOrderProducts($order_info['order_id']);
        $last_index = 0;
        foreach ($order_items as $item) {
            $name = $item["name"];
            $tax_in_percent = $item['tax']/($item['price']/100);
            $price = $this->currency->format(
                floatval($item['price']+$item['tax']),
                $order_info['currency_code'],
                $order_info['currency_value'],
                false
            );
            $quantity = floatval($item['quantity']);
            $tax_rate = round($tax_in_percent);
            $taxes = $pk_obj->setTaxes($tax_rate);

            if ($quantity == 1 && $pk_obj->single_item_index < 0) {
                $pk_obj->single_item_index = $last_index;
            }
            if ($quantity > 1 && $pk_obj->more_then_one_item_index < 0) {
                $pk_obj->more_then_one_item_index = $last_index;
            }

            $pk_obj->updateFiscalCart(
                $pk_obj->getPaymentFormType(),
                $name,
                $price,
                $quantity,
                0,
                $taxes["tax"]
            );
            $last_index++;
        }

        //add shipping parameters to cart
        if (array_key_exists('shipping_code', $order_info) && !empty($order_info['shipping_code'])) {
            $shipping_taxes = array("tax" => "none", "tax_sum" => 0);
            $shipping_code = substr($order_info['shipping_code'], 0, strpos($order_info['shipping_code'], "."));
            $this->load->model('shipping/' . $shipping_code);
            $shipping_address = array(
                "country_id" => $order_info['shipping_country_id'],
                "zone_id" => $order_info['shipping_zone_id']
            );
            $shipping_method = $this->{'model_shipping_' . $shipping_code}->getQuote($shipping_address);

            if ($shipping_method != null) {
                $pk_obj->setShippingPrice(
                    $this->currency->format(
                        floatval($shipping_method['quote'][$shipping_code]['cost']),
                        $order_info['currency_code'],
                        $order_info['currency_value'],
                        false
                    )
                );
                $shipping_name = $shipping_method['quote'][$shipping_code]['title'];
                $shipping_tax_class_id = $shipping_method['quote'][$shipping_code]['tax_class_id'];
            }
            else {
                $pk_obj->setShippingPrice(
                    $this->currency->format(
                        floatval($this->session->data['shipping_method']['cost']),
                        $order_info['currency_code'],
                        $order_info['currency_value'],
                        false
                    )
                );
                $shipping_name = $this->session->data['shipping_method']['title'];
                $shipping_tax_class_id = $this->session->data["shipping_method"]["tax_class_id"];
            }

            if (!$pk_obj->checkDeliveryIncluded($pk_obj->getShippingPrice(), $shipping_name)
                && $pk_obj->getShippingPrice() > 0)
            {
                $shipping_tax_final = 0;
                if ($shipping_tax_class_id > 0) {
                    $shipping_tax_rate_data = $this->cart->tax->getRates($pk_obj->getShippingPrice(), $shipping_tax_class_id);
                    $shipping_tax_rate_data = reset($shipping_tax_rate_data);
                    $shipping_tax_rate      = (int) $shipping_tax_rate_data["rate"];
                    $shipping_taxes         = $pk_obj->setTaxes($shipping_tax_rate);
                    $shipping_tax_final     += $shipping_tax_rate_data['amount'];
                }
                $pk_obj->setUseDelivery(); //for precision correct check
                $pk_obj->updateFiscalCart(
                    $pk_obj->getPaymentFormType(),
                    $shipping_name,
                    $pk_obj->getShippingPrice()+$shipping_tax_final,
                    1,
                    0,
                    $shipping_taxes["tax"]
                );
                $pk_obj->delivery_index = $last_index;
                $pk_obj->fiscal_cart[$last_index]['item_type'] = 'service';
            }
        }

        //set discounts
        $pk_obj->setDiscounts((array_key_exists("coupon", $this->session->data) || $this->config->get("paykeeper_force_discounts_check") == "1"));

        //handle possible precision problem
        $pk_obj->correctPrecision();

        $fiscal_cart_encoded = json_encode($pk_obj->getFiscalCart());

        //generate payment form
        $form = "";
        if ($pk_obj->getPaymentFormType() == "create") { //create form
            $to_hash = number_format($pk_obj->getOrderTotal(), 2, ".", "") .
                $pk_obj->getOrderParams("clientid")     .
                $pk_obj->getOrderParams("orderid")      .
                $pk_obj->getOrderParams("service_name") .
                $pk_obj->getOrderParams("client_email") .
                $pk_obj->getOrderParams("client_phone") .
                $pk_obj->getOrderParams("secret_key");
            $sign = hash ('sha256' , $to_hash);
            $form .= '
                <h3>Сейчас Вы будете перенаправлены на страницу банка.</h3>
                <form name="payment" id="pay_form" action="'.$pk_obj->getOrderParams("form_url").'" accept-charset="utf-8" method="post">
                <input type="hidden" name="sum" value = "'.$pk_obj->getOrderTotal().'"/>
                <input type="hidden" name="orderid" value = "'.$pk_obj->getOrderParams("orderid").'"/>
                <input type="hidden" name="clientid" value = "'.$pk_obj->getOrderParams("clientid").'"/>
                <input type="hidden" name="client_email" value = "'.$pk_obj->getOrderParams("client_email").'"/>
                <input type="hidden" name="client_phone" value = "'.$pk_obj->getOrderParams("client_phone").'"/>
                <input type="hidden" name="service_name" value = "'.$pk_obj->getOrderParams("service_name").'"/>
                <input type="hidden" name="cart" value = \''.htmlentities($fiscal_cart_encoded,ENT_QUOTES).'\' />
                <input type="hidden" name="sign" value = "'.$sign. '"/>
                <input type="submit" id="button-confirm" value="Оплатить"/>
                </form>
                <script>
                async function paykeeper_form_send() {
                    let response = await fetch("index.php?route=payment/paykeeper/confirm");
                    if (response.ok) {
                        document.getElementById("pay_form").submit();
                    }
                }

                if (document.readyState === "loading") {
                    document.addEventListener("DOMContentLoaded", paykeeper_form_send);
                } else {
                    paykeeper_form_send();
                }

                document.getElementById("button-confirm").addEventListener("click", paykeeper_form_send);
                </script>';
        }
        else { //order form
            $payment_parameters = array(
                "clientid"=>$pk_obj->getOrderParams("clientid"),
                "orderid"=>$pk_obj->getOrderParams('orderid'),
                "sum"=>$pk_obj->getOrderTotal(),
                "phone"=>$pk_obj->getOrderParams("phone"),
                "client_email"=>$pk_obj->getOrderParams("client_email"),
                "cart"=>$fiscal_cart_encoded);
            $query = http_build_query($payment_parameters);
            $query_options = array("http"=>array(
                "method"=>"POST",
                "header"=>"Content-type: application/x-www-form-urlencoded",
                "content"=>$query
            ));
            $context = stream_context_create($query_options);

            if( function_exists( "curl_init" )) { //using curl
                $CR = curl_init();
                curl_setopt($CR, CURLOPT_URL, $pk_obj->getOrderParams("form_url"));
                curl_setopt($CR, CURLOPT_POST, 1);
                curl_setopt($CR, CURLOPT_FAILONERROR, true);
                curl_setopt($CR, CURLOPT_POSTFIELDS, $query);
                curl_setopt($CR, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($CR, CURLOPT_SSL_VERIFYPEER, 0);
                $result = curl_exec( $CR );
                $error = curl_error( $CR );
                if( !empty( $error )) {
                    $form .= "<br/><span class=message>"."INTERNAL ERROR:".$error."</span>";
                }
                else {
                    $form .= $result;
                }

                curl_close($CR);
            }
            else { //using file_get_contents
                if (!ini_get('allow_url_fopen')) {
                    $form .= "<br/><span class=message>"."INTERNAL ERROR: Option allow_url_fopen is not set in php.ini"."</span>";
                }
                else {
                    $form .= file_get_contents($pk_obj->getOrderParams("form_url"), false, $context);
                }
            }
        }
        if ($form == "") {
            $form = '<h3>Произошла ошибка при инциализации платежа</h3><p>Sending the request failed</p>';
        }

        $data["form"] = $form;

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/paykeeper_iframe.tpl')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/payment/paykeeper_iframe.tpl', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/payment/paykeeper_iframe.tpl', $data));
        }
    }
    public function success() {

        $this->load->language('checkout/checkout');
        $this->load->language('payment/paykeeper');

        //clear cart
        $this->cart->clear();

        $data['heading_title'] = $this->language->get('paykeeper_title');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_cart'),
            'href' => $this->url->link('checkout/cart')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('checkout/checkout', '', 'SSL')
        );

        $data['message'] = $this->language->get('paykeeper_success');

        $this->document->setTitle($data['message']);

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/paykeeper_feedback.tpl')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/payment/paykeeper_feedback.tpl', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/payment/paykeeper_feedback.tpl', $data));
        }
    }

    public function failed()
    {
        $this->load->language('checkout/checkout');
        $this->load->language('payment/paykeeper');

        $data['heading_title'] = $this->language->get('paykeeper_title');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_cart'),
            'href' => $this->url->link('checkout/cart')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('checkout/checkout', '', 'SSL')
        );

        $data['message'] = $this->language->get('paykeeper_failed');

        $this->document->setTitle($data['message']);

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/paykeeper_feedback.tpl')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/payment/paykeeper_feedback.tpl', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/payment/paykeeper_feedback.tpl', $data));
        }
    }

    public function confirm()
    {
        $this->load->model('checkout/order');
        $this->model_checkout_order->addOrderHistory($this->session->data['order_id'], 1);
    }
}
